/*
Nesta segunda etapa, deixamos ligado o buzzer, que está conectado no pino 10 (lado positivo) e no GND (lado negativo) em série com um resistor de 100 ohms.
Ligamos um LED azul, conectado com a parte positiva no pino 9 e a negativa em série com um resistor de 220 ohms no GND.
Também vamos ligar o botão/ interruptor azul, com um lado no pino 8 e o outro no GND
*/
#define pinoBuzzer 10 // se você ligou em outro pino, ajuste aqui
#define LEDAzul 9 // parte positiva no pino 9 e a negativa em série com um resistor de 220 ohms no GND
#define botaoAzul 8 // um lado no pino 8 e o outro no GND

void setup() {
  pinMode(pinoBuzzer, OUTPUT);  // é uma saída
  pinMode(LEDAzul, OUTPUT); // é uma saída
  pinMode(botaoAzul, INPUT_PULLUP); // entrada que estará alta se não estiver pressionado o botão
  somPerdeu(); //executa a função 'somPerdeu'
  delay(800); // aguarda 800 ms
  somGanhou();//executa a função 'somGanhou'
}

void loop() {
  if(digitalRead(botaoAzul) == LOW){
    // se o botão foi pressionado
    digitalWrite(LEDAzul, HIGH); // acende o LED azul
    tone(pinoBuzzer, 494, 200); // som de 494 Hz
  }
  else{
    // se o botão não estiver pressionado
    digitalWrite(LEDAzul, LOW); // apaga o LED azul
    noTone(pinoBuzzer); // sem som  
  }
}

void somPerdeu(){
  //do código da SparkFun
  tone(pinoBuzzer, 130, 250);   //E6
  delay(275);
  tone(pinoBuzzer, 73, 250);   //G6
  delay(275);
  tone(pinoBuzzer, 65, 150);   //E7
  delay(175);
  tone(pinoBuzzer, 98, 500);   //C7
  delay(500);
}

void somGanhou(){
  //do código da SparkFun
  tone(pinoBuzzer, 1318, 150);   //E6
  delay(175);
  tone(pinoBuzzer, 1567, 150);   //G6
  delay(175);
  tone(pinoBuzzer, 2637, 150);   //E7
  delay(175);
  tone(pinoBuzzer, 2093, 150);   //C7
  delay(175);
  tone(pinoBuzzer, 2349, 150);   //D7
  delay(175);
  tone(pinoBuzzer, 3135, 500);   //G7
  delay(500);
}
