/*
Seu hardware está ok, agora vamos programar.
Agora quando os soms de ganhou e perdeu tocarem, os leds acompanham.
*/
#define pinoBuzzer 10 // se você ligou em outro pino, ajuste aqui
#define LEDAzul 9 // parte positiva no pino 9 e a negativa em série com um resistor de 220 ohms no GND
#define botaoAzul 8 // um lado no pino 8 e o outro no GND
#define LEDVerde 7 // parte positiva no pino 7 e a negativa em série com um resistor de 220 ohms no GND
#define botaoVerde 6 // um lado no pino 6 e o outro no GND
#define LEDAmarelo 5 // parte positiva no pino 5 e a negativa em série com um resistor de 220 ohms no GND
#define botaoAmarelo 4 // um lado no pino 4 e o outro no GND
#define LEDVermelho 3 // parte positiva no pino 3 e a negativa em série com um resistor de 220 ohms no GND
#define botaoVermelho 2 // um lado no pino 2 e o outro no GND

void setup() {
  pinMode(pinoBuzzer, OUTPUT);  // é uma saída
  pinMode(LEDAzul, OUTPUT); // é uma saída
  pinMode(botaoAzul, INPUT_PULLUP); // entrada que estará alta se não estiver pressionado o botão
  pinMode(LEDVerde, OUTPUT); // é uma saída
  pinMode(botaoVerde, INPUT_PULLUP); // entrada que estará alta se não estiver pressionado o botão  
  pinMode(LEDAmarelo, OUTPUT); // é uma saída
  pinMode(botaoAmarelo, INPUT_PULLUP); // entrada que estará alta se não estiver pressionado o botão 
  pinMode(LEDVermelho, OUTPUT); // é uma saída
  pinMode(botaoVermelho, INPUT_PULLUP); // entrada que estará alta se não estiver pressionado o botão 
  somPerdeu(); //executa a função 'somPerdeu'
  delay(800); // aguarda 800 ms
  somGanhou();//executa a função 'somGanhou'
}

void loop() {
  if(digitalRead(botaoAzul) == LOW){
    // se o botão foi pressionado
    digitalWrite(LEDAzul, HIGH); // acende o LED azul
    tone(pinoBuzzer, 494, 200); // som de 494 Hz
  }
  else{
    // se o botão não estiver pressionado
    digitalWrite(LEDAzul, LOW); // apaga o LED azul
    noTone(pinoBuzzer); // sem som  
  }
  if(digitalRead(botaoVerde) == LOW){
    // se o botão foi pressionado
    digitalWrite(LEDVerde, HIGH); // acende o LED verde
    tone(pinoBuzzer, 392, 200); // som de 392 Hz
  }
  else{
    // se o botão não estiver pressionado
    digitalWrite(LEDVerde, LOW); // apaga o LED verde
    noTone(pinoBuzzer); // sem som  
  }  
  if(digitalRead(botaoAmarelo) == LOW){
    // se o botão foi pressionado
    digitalWrite(LEDAmarelo, HIGH); // acende o LED amarelo
    tone(pinoBuzzer, 330, 200); // som de 330 Hz
  }
  else{
    // se o botão não estiver pressionado
    digitalWrite(LEDAmarelo, LOW); // apaga o LED vermelho
    noTone(pinoBuzzer); // sem som  
  }  
  if(digitalRead(botaoVermelho) == LOW){
    // se o botão foi pressionado
    digitalWrite(LEDVermelho, HIGH); // acende o LED vermelho
    tone(pinoBuzzer, 330, 200); // som de 330 Hz
  }
  else{
    // se o botão não estiver pressionado
    digitalWrite(LEDVermelho, LOW); // apaga o LED amarelo
    noTone(pinoBuzzer); // sem som  
  }     
}

void somPerdeu(){
  //do código da SparkFun
  digitalWrite(LEDAzul, HIGH); // acende o LED azul
  tone(pinoBuzzer, 130, 250);   //E6
  delay(275);
  digitalWrite(LEDAzul, LOW); // apaga o LED azul
  digitalWrite(LEDVermelho, HIGH); // acende o LED vermelho
  tone(pinoBuzzer, 73, 250);   //G6
  delay(275);
  digitalWrite(LEDVermelho, LOW); // apaga o LED amarelo
  digitalWrite(LEDAmarelo, HIGH); // acende o LED amarelo
  tone(pinoBuzzer, 65, 150);   //E7
  delay(175);
  digitalWrite(LEDAmarelo, LOW); // apaga o LED vermelho
  digitalWrite(LEDVerde, HIGH); // acende o LED verde
  tone(pinoBuzzer, 98, 500);   //C7
  delay(500);
  digitalWrite(LEDVerde, LOW); // apaga o LED verde
}

void somGanhou(){
  //do código da SparkFun
  digitalWrite(LEDAzul, HIGH); // acende o LED azul
  tone(pinoBuzzer, 1318, 150);   //E6
  delay(175);
  digitalWrite(LEDAzul, LOW); // apaga o LED azul
  digitalWrite(LEDVermelho, HIGH); // acende o LED vermelho
  tone(pinoBuzzer, 1567, 150);   //G6
  delay(175);
  digitalWrite(LEDVermelho, LOW); // apaga o LED amarelo
  digitalWrite(LEDAmarelo, HIGH); // acende o LED amarelo
  tone(pinoBuzzer, 2637, 150);   //E7
  delay(175);
  digitalWrite(LEDAmarelo, LOW); // apaga o LED vermelho
  digitalWrite(LEDVerde, HIGH); // acende o LED verde
  tone(pinoBuzzer, 2093, 150);   //C7
  delay(175);
  digitalWrite(LEDAzul, HIGH); // acende o LED azul
  digitalWrite(LEDVermelho, HIGH); // acende o LED vermelho
  digitalWrite(LEDAmarelo, HIGH); // acende o LED amarelo
  tone(pinoBuzzer, 2349, 150);   //D7
  delay(175);
  tone(pinoBuzzer, 3135, 500);   //G7
  digitalWrite(LEDAzul, LOW); // apaga o LED azul
  digitalWrite(LEDVermelho, LOW); // apaga o LED amarelo
  digitalWrite(LEDAmarelo, LOW); // apaga o LED vermelho
  digitalWrite(LEDVerde, LOW); // apaga o LED verde
  delay(500);
}
