#include <AFMotor.h>  //esta é a biblioteca ‘Adafruit Motor Shield library’ que instalamos
#include "IRremote.h" //estes arquivos devem estar na mesma pasta que o '.ino'

#define pinoControle A0 //porta em que foi ligado o sensor IR

IRrecv receptor(pinoControle);

decode_results resultados;

byte tecla;

AF_DCMotor mEsq(3); //AF_DCMotor é o objeto; mEsq o nome da variável; '3' foi a porta escolhida 
AF_DCMotor mDir(4); //motor 'mDir' ligado na porta 4

void setup() 
{
  //note que não usamos o 'pinMode', pois a declaração do objeto 'AF_DCMotor' já faz isso
  //idem para o controle 
  
  Serial.begin(9600);
  receptor.enableIRIn();  
  //velocidade inicial - vai de 0 até 255
  mEsq.setSpeed(150);
  mDir.setSpeed(150);
  
  //parar os motores
  mEsq.run(RELEASE); //'run' controla o motor e o parâmetro 'RELEASE' desliga o motor
  mDir.run(RELEASE);
}


void loop() {
  if (receptor.decode(&resultados)) {
    if(resultados.value != 0xFFFFFFFF){
      tecla = resultados.value;
      Serial.println(tecla);
    }
    switch (tecla){
      case 199: //lembre-se de que o valor depende de cada controle remoto
        Serial.println("OK");
        mEsq.run(RELEASE); //'RELEASE' desliga o motor
        mDir.run(RELEASE);
        break;
      case 231:
        Serial.println("Tecla Para Cima");
        mEsq.run(BACKWARD); //motor no sentido 'para frente'
        mDir.run(BACKWARD);
        break;
      case 181:
        Serial.println("Tecla Para Baixo");
        mEsq.run(FORWARD); //motor no sentido 'para trás'
        mDir.run(FORWARD);
        break;   
      case 239:
        Serial.println("Tecla Para Esquerda");
        mEsq.run(FORWARD);
        mDir.run(RELEASE);
        break;
      case 165:
        Serial.println("Tecla Para Direita");
        mEsq.run(BACKWARD);
        mDir.run(RELEASE);
        break;              
    }
    receptor.resume(); //prepara para o próximo valor
  }
}
