#include <AFMotor.h>
#include <Servo.h>

#define PinoEcho A1
#define PinoTrigger A2

const int PinoServoMotor = 10;

int velocidade = 150;
int limite = 15;
int distancia = 200;

AF_DCMotor mEsq(3);
AF_DCMotor mDir(4);

Servo meuServo;

void seguirReto(){   
    mEsq.run(FORWARD);
    mDir.run(FORWARD);    
}

void voltarReto(){   
    mEsq.run(BACKWARD);
    mDir.run(BACKWARD);    
}

void seguirEsquerda(){ 
    mEsq.run(RELEASE);   
    mDir.run(FORWARD);  
}

void seguirDireita(){
    mDir.run(RELEASE);    
    mEsq.run(FORWARD); 
}

void parar(){
   mEsq.run(RELEASE);
   mDir.run(RELEASE);   
}

void setup() 
{
  pinMode(PinoTrigger, OUTPUT); 
  pinMode(PinoEcho, INPUT); 
  mEsq.setSpeed(velocidade);
  mDir.setSpeed(velocidade);
  meuServo.attach(PinoServoMotor);    
}

int calculaDistancia(){
  //primeiramente, desliga a emissão de ultrassom
  digitalWrite(PinoTrigger,LOW);
  //aguarda 0,000003 segundos (3 microssengundos)
  delayMicroseconds(3);
  //coloca em alto o pino trigger, o que faz com que o sensor emita ultrassom
  digitalWrite(PinoTrigger,HIGH);
  //aguarda 0,000010 segundos (10 microssegundos), conforme o datasheet
  delayMicroseconds(10);
  //desliga a emissão de ultrassom
  digitalWrite(PinoTrigger,LOW);
  // aguarda pelo echo; tempoUs corresponde ao tempo em microssegundos que demorou para o sinal voltar
  float tempoUs = pulseIn(PinoEcho, HIGH); // microseconds
  //conforme o datasheet consultado, divide o tempo por 58 para saber a distância em centímetros
  //se dividir por 148 dá a distância em polegadas
  //retorna o resultado da divisão
  return (int)(tempoUs / 58); // assume velocidade do som no ar de 340 m/s = 2.9ms/mm
}

void loop() {
  
  parar();
  meuServo.write(90);  
  delay(50);
  seguirReto();

  distancia = calculaDistancia();
  
  if (distancia < limite){
    parar();
    delay(20);
    voltarReto();   
    delay(250);

    meuServo.write(45);
    int esquerda = calculaDistancia();
    delay(50);
    meuServo.write(135);
    int direita = calculaDistancia();
    
    if ( esquerda < direita ){
       seguirDireita();
       delay(300);          
    }
    else {
       seguirEsquerda();
       delay(300); 
    }
  }
}
