/*RGB por temperatura de cor direto da biblioteca*/
#include "U8glib.h"
#include "Adafruit_TCS34725.h"

#define tiranossauro_width 110
#define tiranossauro_height 50
#define botao 6

U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NONE);
Adafruit_TCS34725 tcs = Adafruit_TCS34725(TCS34725_INTEGRATIONTIME_2_4MS, TCS34725_GAIN_1X); //TCS34725_INTEGRATIONTIME_614MS
uint16_t r, g, b, c, colorTemp, lux;

static unsigned char tiranossauro_bits[]  U8G_PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xFE, 0xC0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xC0, 0x01, 0xF7, 0xFC, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0xFC, 0x09, 0x1E, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xE8, 0x01, 
  0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 
  0xE0, 0x31, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x2C, 0x00, 0x00, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x04, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xC0, 0x1F, 0x00, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xB8, 0x0D, 0x00, 0x04, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0xFF, 0x0D, 
  0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 
  0x3C, 0x0F, 0x00, 0x08, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xB8, 0x99, 0xA7, 0x09, 0xC0, 0xF0, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xB8, 0xFB, 0xE6, 0x04, 0xC0, 0x80, 0x03, 0xFC, 0x01, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xCE, 0xA0, 0x03, 0xC0, 0x00, 0x00, 0xC0, 
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x01, 0x40, 0x00, 
  0xE0, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x00, 
  0x20, 0x00, 0x04, 0x60, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x4D, 0x00, 0x18, 0x00, 0x04, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x80, 0x3F, 0x00, 0x0E, 0x00, 0x06, 0x00, 0x80, 0x1F, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x19, 0xC0, 0x19, 0x00, 0x02, 0x00, 0x03, 0xFC, 
  0x01, 0x00, 0x00, 0x0F, 0x00, 0xF0, 0x0F, 0x70, 0x30, 0x00, 0x03, 0x00, 
  0x03, 0xE0, 0xFF, 0xC3, 0xFF, 0x0F, 0x00, 0x3C, 0x07, 0x1C, 0x60, 0x01, 
  0x03, 0x00, 0x03, 0x00, 0xFC, 0xFF, 0x3F, 0x03, 0x00, 0xF4, 0x01, 0x07, 
  0xC0, 0x11, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x6C, 
  0xC0, 0x01, 0xC0, 0x18, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x60, 0x00, 
  0x00, 0x38, 0x70, 0x00, 0xE0, 0x06, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x08, 0x1C, 0x00, 0x70, 0x07, 0x02, 0xC0, 0x00, 0x00, 
  0x00, 0x00, 0x07, 0x00, 0x00, 0x98, 0x03, 0x00, 0x9C, 0x19, 0x06, 0x60, 
  0x00, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x8E, 0x70, 
  0x04, 0x60, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xFF, 0xC0, 0x09, 0xC0, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x6F, 0x00, 0x3E, 0x80, 0xFF, 0xFF, 0x1F, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x60, 0x80, 0x03, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x80, 0x01, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x40, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x60, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x30, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x70, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x0F, 0x38, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x38, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCE, 
  0x07, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x66, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x3C, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, };
  
void setup() {
  pinMode(botao, INPUT_PULLUP);
  if (tcs.begin()) {
    Serial.println("Sensor ok");
  } else {
    Serial.println("TCS34725 nao ativo");
    while (1);
  }  
  u8g.setColorIndex(1);
  u8g.firstPage();  
  do {
    mostraLogo();
  } 
  while(u8g.nextPage()); 
}


void loop() {
  while(1){
    if(digitalRead(botao) == LOW){
      atualiza();
      break;
    }
  }  
  u8g.firstPage();  
  do{
    mostraLeitura();
    } 
  while(u8g.nextPage()); 
}

void mostraLogo() {
  //u8g.setFont(u8g_font_courB14);
  u8g.drawXBMP( 10, 12, tiranossauro_width, tiranossauro_height, tiranossauro_bits); 
  u8g.setFont(u8g_font_courR10);
  u8g.drawStr( 16, 10, "CyberColor 2"); //coluna, linha
} 

void atualiza(){  
  tcs.getRawData(&r, &g, &b, &c);
  colorTemp = tcs.calculateColorTemperature(r, g, b);
  //colorTemp = tcs.calculateColorTemperature_dn40(r, g, b, c);
  lux = tcs.calculateLux(r, g, b);
	auto temp = colorTemp / 100;
	if (temp <= 66)
	{
		r = 255;
		g = 99.4708025861 * log(temp) - 161.1195681661;

		if (temp <= 19)
		{
			b = 0;
		}
		else
		{
			b = 138.5177312231 * log(temp - 10) - 305.0447927307;
		}
	}
	else
	{
		r = 329.698727446 * pow(temp - 60, -0.1332047592);
		g = 288.1221695283 * pow(temp - 60, -0.0755148492);
		b = 255;
	}


}

void mostraLeitura(){
  u8g.setColorIndex(1); 
  u8g.setFont(u8g_font_unifont);
  u8g.setPrintPos(16, 10);
  u8g.print("CyberColor 2");
  //u8g.setFont(u8g_font_7x13);

  u8g.setPrintPos(0, 26);
  u8g.print("Luz");
  u8g.setPrintPos(40, 26);
  u8g.print(lux);
  u8g.setPrintPos(80, 26);
  u8g.print(colorTemp);  

  u8g.setPrintPos(25, 38);
  u8g.print("Verm");
  u8g.setPrintPos(70, 38);
  u8g.print(r);

  u8g.setPrintPos(25, 50);
  u8g.print("Verde");
  u8g.setPrintPos(70, 50);
  u8g.print(g, DEC);

  u8g.setPrintPos(25, 62);
  u8g.print("Azul");
  u8g.setPrintPos(70, 62);
  u8g.print(b, DEC);
}

/*
typedef enum
{
  TCS34725_INTEGRATIONTIME_2_4MS  = 0xFF,   //<  2.4ms - 1 cycle    - Max Count: 1024  
  TCS34725_INTEGRATIONTIME_24MS   = 0xF6,   //<  24ms  - 10 cycles  - Max Count: 10240 
  TCS34725_INTEGRATIONTIME_50MS   = 0xEB,   //<  50ms  - 20 cycles  - Max Count: 20480 
  TCS34725_INTEGRATIONTIME_101MS  = 0xD5,   //<  101ms - 42 cycles  - Max Count: 43008 
  TCS34725_INTEGRATIONTIME_154MS  = 0xC0,   //<  154ms - 64 cycles  - Max Count: 65535 
  TCS34725_INTEGRATIONTIME_700MS  = 0x00    //<  700ms - 256 cycles - Max Count: 65535 
}
*/
