/*RGB pela biblioteca TCS34725 (não é da Adafruit)*/
#include "U8glib.h"
#include "DEV_Config.h"
#include "TCS34725.h"

#define tiranossauro_width 110
#define tiranossauro_height 50
#define botao 6

U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NONE);
RGB rgb, leitura;

static unsigned char tiranossauro_bits[]  U8G_PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xFE, 0xC0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xC0, 0x01, 0xF7, 0xFC, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0xFC, 0x09, 0x1E, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xE8, 0x01, 
  0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 
  0xE0, 0x31, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x2C, 0x00, 0x00, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x04, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xC0, 0x1F, 0x00, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xB8, 0x0D, 0x00, 0x04, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0xFF, 0x0D, 
  0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 
  0x3C, 0x0F, 0x00, 0x08, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xB8, 0x99, 0xA7, 0x09, 0xC0, 0xF0, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xB8, 0xFB, 0xE6, 0x04, 0xC0, 0x80, 0x03, 0xFC, 0x01, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xCE, 0xA0, 0x03, 0xC0, 0x00, 0x00, 0xC0, 
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x01, 0x40, 0x00, 
  0xE0, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x00, 
  0x20, 0x00, 0x04, 0x60, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x4D, 0x00, 0x18, 0x00, 0x04, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x80, 0x3F, 0x00, 0x0E, 0x00, 0x06, 0x00, 0x80, 0x1F, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x19, 0xC0, 0x19, 0x00, 0x02, 0x00, 0x03, 0xFC, 
  0x01, 0x00, 0x00, 0x0F, 0x00, 0xF0, 0x0F, 0x70, 0x30, 0x00, 0x03, 0x00, 
  0x03, 0xE0, 0xFF, 0xC3, 0xFF, 0x0F, 0x00, 0x3C, 0x07, 0x1C, 0x60, 0x01, 
  0x03, 0x00, 0x03, 0x00, 0xFC, 0xFF, 0x3F, 0x03, 0x00, 0xF4, 0x01, 0x07, 
  0xC0, 0x11, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x6C, 
  0xC0, 0x01, 0xC0, 0x18, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x60, 0x00, 
  0x00, 0x38, 0x70, 0x00, 0xE0, 0x06, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x08, 0x1C, 0x00, 0x70, 0x07, 0x02, 0xC0, 0x00, 0x00, 
  0x00, 0x00, 0x07, 0x00, 0x00, 0x98, 0x03, 0x00, 0x9C, 0x19, 0x06, 0x60, 
  0x00, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x8E, 0x70, 
  0x04, 0x60, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xFF, 0xC0, 0x09, 0xC0, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x6F, 0x00, 0x3E, 0x80, 0xFF, 0xFF, 0x1F, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x60, 0x80, 0x03, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x80, 0x01, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x40, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x60, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x30, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x70, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x0F, 0x38, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x38, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCE, 
  0x07, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x66, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x3C, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, };
  
void setup() {
  Config_Init();
  pinMode(botao, INPUT_PULLUP);
  if(TCS34725_Init() != 0){
      Serial.print("TCS34725 nao ativo\n");
      while (1); 
  } 
  u8g.setColorIndex(1);
  u8g.firstPage();  
  do {
    mostraLogo();
  } 
  while(u8g.nextPage()); 
}


void loop() {
  while(1){
    if(digitalRead(botao) == LOW){
      atualiza();
      break;
    }
  }  
  u8g.firstPage();  
  do{
    mostraLeitura();
    } 
  while(u8g.nextPage()); 
}

void mostraLogo() {
  //u8g.setFont(u8g_font_courB14);
  u8g.drawXBMP( 10, 12, tiranossauro_width, tiranossauro_height, tiranossauro_bits); 
  u8g.setFont(u8g_font_courR10);
  u8g.drawStr( 16, 10, "CyberColor 4"); //coluna, linha
} 

void atualiza(){ 
 
  rgb = TCS34725_Get_RGBData(); 
  leitura = TCS34725_GetRGB888(rgb);
  /*
  Serial.print("RGB 8bits: R=");
  Serial.print(leitura.R);
  Serial.print(" G=");
  Serial.print(leitura.G);
  Serial.print(" B=");
  Serial.print(leitura.B);
  Serial.print("\r\n");  
  */
}

void mostraLeitura(){
  u8g.setColorIndex(1); 
  u8g.setFont(u8g_font_unifont);
  u8g.setPrintPos(16, 10);
  u8g.print("CyberColor 4");
  u8g.setFont(u8g_font_7x13);

  u8g.setPrintPos(0, 26);
  u8g.print("Luz");
  u8g.setPrintPos(40, 26);
  u8g.print(leitura.C);

  u8g.setPrintPos(25, 38);
  u8g.print("Verm");
  u8g.setPrintPos(70, 38);
  u8g.print(leitura.R);

  u8g.setPrintPos(25, 50);
  u8g.print("Verde");
  u8g.setPrintPos(70, 50);
  u8g.print(leitura.G);

  u8g.setPrintPos(25, 62);
  u8g.print("Azul");
  u8g.setPrintPos(70, 62);
  u8g.print(leitura.B);
}

/*
  TCS34725_INTEGRATIONTIME_2_4MS    
  TCS34725_INTEGRATIONTIME_24MS   
  TCS34725_INTEGRATIONTIME_50MS  
  TCS34725_INTEGRATIONTIME_101MS  
  TCS34725_INTEGRATIONTIME_154MS 
  TCS34725_INTEGRATIONTIME_700MS 

  TCS34725_GAIN_1X          
  TCS34725_GAIN_4X    
  TCS34725_GAIN_16X          
  TCS34725_GAIN_60X          
*/
