/*RGB pela biblioteca TCS34725 (não é da Adafruit)*/
#include "U8glib.h"
#include "DEV_Config.h"
#include "TCS34725.h"

#define tiranossauro_width 110
#define tiranossauro_height 50
#define botao 6
#define ledSensor 8

U8GLIB_SSD1306_128X64 u8g(U8G_I2C_OPT_NONE);
RGB rgb, rgbLe;

static unsigned char tiranossauro_bits[]  U8G_PROGMEM = {
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0xFE, 0xC0, 0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xC0, 0x01, 0xF7, 0xFC, 0x01, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x20, 0x00, 0xFC, 0x09, 0x1E, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x00, 0xE8, 0x01, 
  0x70, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x68, 0x00, 
  0xE0, 0x31, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x2C, 0x00, 0x00, 0x20, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x04, 0x00, 0x00, 0x30, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xC0, 0x1F, 0x00, 0x06, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x04, 0x00, 0xB8, 0x0D, 0x00, 0x04, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x00, 0xFF, 0x0D, 
  0x00, 0x0C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF8, 0xFF, 
  0x3C, 0x0F, 0x00, 0x08, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xB8, 0x99, 0xA7, 0x09, 0xC0, 0xF0, 0xFF, 0x7F, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0xB8, 0xFB, 0xE6, 0x04, 0xC0, 0x80, 0x03, 0xFC, 0x01, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0xF8, 0xCE, 0xA0, 0x03, 0xC0, 0x00, 0x00, 0xC0, 
  0x07, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x01, 0x40, 0x00, 
  0xE0, 0x3F, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xEC, 0x00, 
  0x20, 0x00, 0x04, 0x60, 0xF8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 
  0x4D, 0x00, 0x18, 0x00, 0x04, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x80, 0x3F, 0x00, 0x0E, 0x00, 0x06, 0x00, 0x80, 0x1F, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x20, 0x19, 0xC0, 0x19, 0x00, 0x02, 0x00, 0x03, 0xFC, 
  0x01, 0x00, 0x00, 0x0F, 0x00, 0xF0, 0x0F, 0x70, 0x30, 0x00, 0x03, 0x00, 
  0x03, 0xE0, 0xFF, 0xC3, 0xFF, 0x0F, 0x00, 0x3C, 0x07, 0x1C, 0x60, 0x01, 
  0x03, 0x00, 0x03, 0x00, 0xFC, 0xFF, 0x3F, 0x03, 0x00, 0xF4, 0x01, 0x07, 
  0xC0, 0x11, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x80, 0x01, 0x00, 0x6C, 
  0xC0, 0x01, 0xC0, 0x18, 0x03, 0x00, 0x01, 0x00, 0x00, 0x00, 0x60, 0x00, 
  0x00, 0x38, 0x70, 0x00, 0xE0, 0x06, 0x03, 0x80, 0x01, 0x00, 0x00, 0x00, 
  0x18, 0x00, 0x00, 0x08, 0x1C, 0x00, 0x70, 0x07, 0x02, 0xC0, 0x00, 0x00, 
  0x00, 0x00, 0x07, 0x00, 0x00, 0x98, 0x03, 0x00, 0x9C, 0x19, 0x06, 0x60, 
  0x00, 0x00, 0x00, 0xC0, 0x01, 0x00, 0x00, 0xE0, 0x00, 0x00, 0x8E, 0x70, 
  0x04, 0x60, 0x00, 0x00, 0x00, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0xFF, 0xC0, 0x09, 0xC0, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x6F, 0x00, 0x3E, 0x80, 0xFF, 0xFF, 0x1F, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x1E, 0x00, 0x60, 0x80, 0x03, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x80, 0x01, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0xC0, 
  0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x40, 0xC0, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x60, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x30, 0xE0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x70, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xC0, 0x0F, 0x38, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFC, 0x07, 0x38, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xCE, 
  0x07, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x66, 0x0C, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x3C, 0xFE, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0xE0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
  0x00, 0x00, 0x00, 0x00, };

  const char *cores[] = {
  "CyberMunsell 4",
  "Desconhecida  ",
  "Branco        ",
  "Preto         ",
  "Azul          ",
  "Amarelo       ",
  "Verde         " };
  
const int amostras = 10;

const uint8_t universo[amostras][4] = {
  { 253, 253, 253, 2 },
  { 225, 252, 251, 2 },  
  { 197, 249, 253, 3 },
  { 190, 241, 245, 3 },
  {  61, 188, 249, 4 },
  {  71, 188, 248, 4 }, 
  { 204, 153, 181, 5 }, 
  { 209, 253, 185, 5 }, 
  { 120, 253, 184, 6 }, 
  { 117, 251, 184, 6 } 
};
  
void setup() {
  Serial.begin(9600);
  pinMode(ledSensor, OUTPUT);
  digitalWrite(ledSensor, LOW);
  Config_Init();
  pinMode(botao, INPUT_PULLUP);
  if(TCS34725_Init() != 0){
      Serial.print("TCS34725 nao ativo\n");
      while (1); 
  } 
  u8g.setColorIndex(1);
  u8g.firstPage();  
  do {
    mostraLogo();
  } 
  while(u8g.nextPage()); 
}

void loop() {
  while(1){
    if(digitalRead(botao) == LOW){
      digitalWrite(ledSensor, HIGH);
      delay(300);
      atualiza();
      //descobre();
      break;
    }
  }  
  u8g.firstPage();  
  do{
    digitalWrite(ledSensor, LOW);
    mostraLeitura();
    } 
  while(u8g.nextPage()); 
}

void mostraLogo() {
  //u8g.setFont(u8g_font_courB14);
  u8g.drawXBMP( 10, 12, tiranossauro_width, tiranossauro_height, tiranossauro_bits); 
  u8g.setFont(u8g_font_courR10);
  //u8g.drawStr( 2, 10, "CyberMunsell 4"); //coluna, linha
  u8g.drawStr( 2, 10, cores[0]);
} 

void atualiza(){ 
  rgbLe = TCS34725_Get_RGBData();  
  rgb = TCS34725_GetRGB888(rgbLe);
  
  Serial.print("RGB 8bits: R=");
  Serial.print(rgb.R);
  Serial.print(" G=");
  Serial.print(rgb.G);
  Serial.print(" B=");
  Serial.print(rgb.B);
  Serial.print("\r\n");  
  
}

void mostraLeitura(){
  u8g.setColorIndex(1); 
  u8g.setFont(u8g_font_7x13);

  u8g.setPrintPos(0, 26);
  u8g.print("Luz");
  u8g.setPrintPos(40, 26);
  u8g.print(rgb.C);

  u8g.setPrintPos(25, 38);
  u8g.print("Verm");
  u8g.setPrintPos(70, 38);
  u8g.print(rgb.R);

  u8g.setPrintPos(25, 50);
  u8g.print("Verde");
  u8g.setPrintPos(70, 50);
  u8g.print(rgb.G);

  u8g.setPrintPos(25, 62);
  u8g.print("Azul");
  u8g.setPrintPos(70, 62);
  u8g.print(rgb.B);

  u8g.setFont(u8g_font_unifont);
  u8g.setPrintPos(2, 10);
  //u8g.print(texto);
  //u8g.print(cores[1]);
  u8g.setPrintPos(2, 10);
  int qual = descobre(rgb.R, rgb.G, rgb.B);
  u8g.print(cores[qual]);   
}


float quadrado(float a) {
  return a*a;
}

float distanciaEuclidiana(uint8_t r, uint8_t g, uint8_t b, uint8_t *s) {
  return sqrt(quadrado(r - s[0]) + quadrado(g - s[1]) + quadrado(b - s[2]));
}

int descobre(uint16_t r, uint16_t g, uint16_t b) {
  int cor = 1;
  float menor = 1000;
  for (int i = 0; i < amostras ; i++) {
    //float distancia = distanciaEuclidiana(r, g, b, universo[i]);
    float distancia = sqrt(quadrado(r - universo[i][0]) + quadrado(g - universo[i][1]) + quadrado(b - universo[i][2]));
    if (distancia < menor) {
      menor = distancia;
      cor = universo[i][3];
    }
  }
  return cor;
}
